package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.GrupoBuzon;
import com.ejie.ab04b.dao.BuzonDao;
import com.ejie.ab04b.model.Buzon;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0476s00ServiceImpl generated by UDA, 07-Feb-2017 13:06:26.
 * 
 * @author UDA
 */

@Service(value = "ab0476s00Service")
public class BuzonServiceImpl implements BuzonService {

	@Autowired()
	private BuzonDao ab0476s00Dao;

	/**
	 * Inserts a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @return the buzon
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Buzon add(Buzon ab0476s00) {
		return this.ab0476s00Dao.add(ab0476s00);
	}

	/**
	 * Updates a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @return the buzon
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Buzon update(Buzon ab0476s00) {
		return this.ab0476s00Dao.update(ab0476s00);
	}

	/**
	 * Finds a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @return the buzon
	 */
	public Buzon find(Buzon ab0476s00) {
		return (Buzon) this.ab0476s00Dao.find(ab0476s00);
	}

	/**
	 * Deletes a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Buzon ab0476s00) {
		this.ab0476s00Dao.remove(ab0476s00);
	}

	/**
	 * Finds a list of rows in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0476s00>
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Buzon> findAll(Buzon ab0476s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Buzon>) this.ab0476s00Dao.findAll(ab0476s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0476s00 table using like.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0476s00>
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Buzon> findAllLike(Buzon ab0476s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Buzon>) this.ab0476s00Dao.findAllLike(ab0476s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0476s00 table.
	 * 
	 *  filterAb0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0476s00>
	 *
	 * @param filterAb0476s00 the filter ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Buzon> filter(Buzon filterAb0476s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Buzon> listaAb0476s00 = this.ab0476s00Dao
				.findAllLike(filterAb0476s00, jqGridRequestDto, false);
		Long recordNum = this.ab0476s00Dao.findAllLikeCount(
				filterAb0476s00 != null ? filterAb0476s00 : new Buzon(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Buzon>> reorderSelection = this.ab0476s00Dao
					.reorderSelection(filterAb0476s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Buzon>(jqGridRequestDto, recordNum,
					listaAb0476s00, reorderSelection);
		}
		return new JQGridResponseDto<Buzon>(jqGridRequestDto, recordNum,
				listaAb0476s00);
	}

	/**
	 * Searches rows in the Ab0476s00 table.
	 * 
	 *  filterAb0476s00
	 *            Ab0476s00
	 *  searchAb0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0476s00>>
	 *
	 * @param filterAb0476s00 the filter ab 0476 s 00
	 * @param searchAb0476s00 the search ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Buzon>> search(Buzon filterAb0476s00,
			Buzon searchAb0476s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0476s00Dao.search(filterAb0476s00, searchAb0476s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0476s00 table.
	 * 
	 *  filterAb0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0476s00 the filter ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Buzon filterAb0476s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0476s00Dao.reorderSelection(filterAb0476s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Obtener buzon.
	 * 
	 *  procedureId            String
	 *  codTerritorio            String
	 *  Buzon
	 *
	 * @param procedureId the procedure id
	 * @param codTerritorio the cod territorio
	 * @return the buzon
	 */
	public Buzon obtenerBuzon(String procedureId, String codTerritorio) {

		Buzon buzon = new Buzon();
		buzon.setCodTerrit076(codTerritorio);

		if (Utilities.getInstance().obtenerProcedureIdApertura()
				.equals(procedureId)) {
			buzon.setGrupo(GrupoBuzon.RESP_TAREA);
		} else {
			buzon.setGrupo(GrupoBuzon.RESP_TAREA_OSALAN);
		}

		return this.find(buzon);
	}
	
	/**
	 * Obtener buzon osalan.
	 * 
	 *  codTerritorio            String
	 *  Buzon
	 *
	 * @param codTerritorio the cod territorio
	 * @return the buzon
	 */
	public Buzon obtenerBuzonOsalan(String codTerritorio) {

		Buzon buzon = new Buzon();
		buzon.setCodTerrit076(codTerritorio);
		buzon.setGrupo(GrupoBuzon.RESP_TAREA_OSALAN);
		
		return this.find(buzon);
	}

}
